/*{
	"GUID":"55D37319-8F37-4593-BBAF-9FF0A6307C01",
	"INPUTS":[
		{
			"TYPE":"image",
			"FILE":"tex12.png"
		}
	],
	"PARAMS":[
		{
			"NAME":"bright",
			"TYPE":"float",
			"DEFAULT":0.0,
			"MIN":0.0,
			"MAX":1.0
		}
	] 
}*/
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

static float myMod(float x, float y)
{
	return x-y * floor (x/y);
}

static vec4 INPUT(image2d_t src_data, vec2 tc, __global FilterParam* param)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, tc.y) );
}


float noise(vec2 p, float iGlobalTime, __read_only image2d_t input2, __global FilterParam* param)
{
	vec2 v = (vec2)(1.f,2.f*cos(iGlobalTime))*iGlobalTime*8.f + p*1.f;
	v.x = myMod(v.x, 1.0f);
	v.y = myMod(v.y, 1.0f);
	float sample = INPUT(input2, v, param).x;
	sample *= sample;
	return sample;
}

float onOff(float a, float b, float c, float iGlobalTime)
{
	return step(c, sin(iGlobalTime + a*cos(iGlobalTime*b)));
}

float ramp(float y, float start, float end)
{
	float inside = step(start,y) - step(end,y);
	float fact = (y-start)/(end-start)*inside;
	return (1.f-fact) * inside;
	
}

float stripes(vec2 uv, float iGlobalTime, __read_only image2d_t input2, __global FilterParam* param)
{
	
	float noi = noise(uv*(vec2)(0.5f,1.f) + (vec2)(1.f,3.f), iGlobalTime, input2, param);
	return ramp(myMod(uv.y*4.f + iGlobalTime/2.f+sin(iGlobalTime + sin(iGlobalTime*0.63f)),1.f),0.5f,0.6f)*noi;
}

vec3 getVideo(vec2 uv, float iGlobalTime,__read_only image2d_t input1, __global FilterParam* param)
{
	vec2 look = uv;
	float window = 1.f/(1.f+20.f*(look.y - myMod(iGlobalTime/4.f,1.f))*(look.y- myMod(iGlobalTime/4.f,1.f)));
	look.x = look.x + (sin(look.y*10.f + iGlobalTime)/50.f*onOff(4.f,4.f,.3f, iGlobalTime)*(1.f+cos(iGlobalTime*80.f))*window);
	float vShift = 0.4f*onOff(2.f,3.f,.9f,iGlobalTime)*(sin(iGlobalTime)*sin(iGlobalTime*20.f) + 
										 (0.5f + 0.1f*sin(iGlobalTime*200.f)*cos(iGlobalTime)));
	look.y = myMod(look.y + (vShift), 1.f);
	vec3 video = INPUT(input1, look, param).xyz;
	return video;
}

vec2 screenDistort(vec2 uv)
{
	uv -= (vec2)(.5f,.5f);
	uv = uv*1.2f*(1.f/1.2f+2.f*uv.x*uv.x*uv.y*uv.y);
	uv += (vec2)(.5f,.5f);
	return uv;
}



__kernel void MAIN(__read_only image2d_t input1, 
	__read_only image2d_t input2,
	__write_only image2d_t dest_data,
	__global FilterParam* param,
	int alpha,
	float bright)
{
	float iGlobalTime = param->cur_time ;
	
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = fragCoord/resolution.xy;
	
	tc = (vec2)(tc.x, tc.y);
	vec2 uv = tc;
	vec4 col = INPUT(input1, tc, param);
	
	vec3 video = getVideo(uv, iGlobalTime, input1, param),xyz;
	float vigAmt = 3.f+.3f*sin(iGlobalTime + 5.f*cos(iGlobalTime*5.f));
	float vignette = (1.f-vigAmt*(uv.y-.5f)*(uv.y-.5f))*(1.f-vigAmt*(uv.x-.5f)*(uv.x-.5f));
	
	video += stripes(uv,iGlobalTime, input2, param) ;
	video += noise(uv*2.f,iGlobalTime, input2, param)/2.f;
	
	float vig = vignette *((12.f)+myMod(uv.y*30.f+iGlobalTime,1.f))/(13.f-(bright)*10.0f);
	//vig = vig * PREFIX(fade) + (1.0-PREFIX(fade));
	video *= vig;
	
	write_imagef(dest_data, (int2)(w, h), col*(1.0f - alpha/100.0f) + (vec4)(video,col.w)*alpha/100.0f);
}